/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.dialog.comp.display.ActualValueSelectionPanel;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BarDisplaySettingPanel
extends DataInputPanel
implements NumericSpinnerListener {
    private static final long serialVersionUID = -3635284142914073191L;
    private JPanel fPanel;
    private ButtonGroup fButtonGroup;
    private JRadioButton fhRadioButton;
    private JRadioButton fvRadioButton;
    private JLabel fDirectionLabel;
    private JLabel fMaxValueLabel;
    private JLabel fMinValueLabel;
    private EditableNumericSpinner fMaxValue;
    private EditableNumericSpinner fMinValue;
    private JPanel fDirectionPanel;
    private JLabel fWidthLabel;
    private JLabel fHeightLabel;
    private EditableNumericSpinner fWidthValue;
    private EditableNumericSpinner fHeightValue;
    private transient BarDisplayElement fBarGraphElement;
    private transient BarDisplayElement barGraphElementNew;
    private LogoDisplay display;
    private WiringDiagram fWD;
    private ActualValueSelectionPanel barselectPanel;
    private Dimension fDisplayDimension;
    private JPanel valuePanel;
    private SplittedDlg sDialog;
    private transient boolean updateAction;

    public BarDisplaySettingPanel(boolean updateAction, LogoDisplay display, BarDisplayElement disp, WiringDiagram wd) {
        this.fDisplayDimension = display.getDisplayDimension();
        this.display = display;
        this.fWD = wd;
        this.updateAction = updateAction;
        this.fBarGraphElement = disp;
        this.initialize();
    }

    private void initialize() {
        this.setName(Language.getString("dialog.parameter.message.setBarTitle", "Bar Setting"));
        this.setBounds(0, 0, 600, 400);
        this.setLayout(new BorderLayout());
        this.setSize(280, 300);
        this.add((Component)this.getBarDisplaySettingPanel(), "Center");
    }

    private JPanel getBarDisplaySettingPanel() {
        if (null == this.fPanel) {
            this.fPanel = new JPanel();
            this.fPanel.setLayout(new GridBagLayout());
            GridBagConstraints barSelectConstraints = new GridBagConstraints();
            barSelectConstraints.gridx = 0;
            barSelectConstraints.gridy = 0;
            barSelectConstraints.gridheight = 1;
            barSelectConstraints.fill = 1;
            barSelectConstraints.anchor = 17;
            barSelectConstraints.insets = new Insets(4, 4, 0, 4);
            this.fPanel.add((Component)this.getBarSelectPanel(), barSelectConstraints);
            GridBagConstraints directionConstraints = new GridBagConstraints();
            directionConstraints.gridx = 0;
            directionConstraints.gridy = 1;
            directionConstraints.gridheight = 1;
            directionConstraints.fill = 1;
            directionConstraints.anchor = 17;
            directionConstraints.insets = new Insets(4, 4, 0, 4);
            this.fPanel.add((Component)this.getValuePanel(), directionConstraints);
            GridBagConstraints valueConstraints = new GridBagConstraints();
            valueConstraints.gridx = 0;
            valueConstraints.gridy = 2;
            valueConstraints.gridheight = 2;
            valueConstraints.fill = 1;
            valueConstraints.anchor = 17;
            valueConstraints.insets = new Insets(4, 4, 0, 4);
            this.fPanel.add((Component)this.getBarPropertyPanel(), valueConstraints);
        }
        return this.fPanel;
    }

    private JPanel getBarSelectPanel() {
        if (null == this.barselectPanel) {
            this.barselectPanel = new ActualValueSelectionPanel(this.fWD);
        }
        return this.barselectPanel;
    }

    private JPanel getDirectionPanel() {
        if (null == this.fDirectionPanel) {
            this.fDirectionPanel = new JPanel();
            this.fButtonGroup = new ButtonGroup();
            this.fhRadioButton = new JRadioButton(Language.getString("dialog.parameter.message.barDirection.horizontal", "Horizontal"), true);
            this.fvRadioButton = new JRadioButton(Language.getString("dialog.parameter.message.barDirection.vertical", "Vertical"));
            this.fButtonGroup.add(this.fhRadioButton);
            this.fButtonGroup.add(this.fvRadioButton);
            this.fDirectionLabel = new JLabel(Language.getString("dialog.parameter.message.setBarDirection", "Direction:"));
            this.fDirectionPanel.add(this.fDirectionLabel);
            this.fDirectionPanel.add(this.fhRadioButton);
            this.fDirectionPanel.add(this.fvRadioButton);
            this.fhRadioButton.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (BarDisplaySettingPanel.this.fhRadioButton.isSelected()) {
                        BarDisplaySettingPanel.this.fWidthValue.setEnabled(true);
                        BarDisplaySettingPanel.this.fHeightValue.setValue(1);
                        BarDisplaySettingPanel.this.fHeightValue.setEnabled(false);
                    } else {
                        BarDisplaySettingPanel.this.fHeightValue.setEnabled(true);
                        BarDisplaySettingPanel.this.fWidthValue.setValue(2);
                        BarDisplaySettingPanel.this.fWidthValue.setEnabled(false);
                    }
                }
            });
        }
        return this.fDirectionPanel;
    }

    private JPanel getValuePanel() {
        if (null == this.valuePanel) {
            this.valuePanel = new JPanel();
            this.fMinValueLabel = new JLabel(Language.getString("dialog.parameter.message.setBarMinLabel", "MinValue:"));
            this.fMaxValueLabel = new JLabel(Language.getString("dialog.parameter.message.setBarMaxLabel", "MaxValue:"));
            this.fMinValue = new EditableNumericSpinner();
            this.fMinValue.setName("minValue");
            this.fMinValue.addNumericSpinnerListener(this);
            this.fMinValue.setMinMax(Short.MIN_VALUE, Short.MAX_VALUE);
            this.fMinValue.setIncrement(1);
            this.fMaxValue = new EditableNumericSpinner();
            this.fMaxValue.setName("maxValue");
            this.fMaxValue.addNumericSpinnerListener(this);
            this.fMaxValue.setMinMax(Short.MIN_VALUE, Short.MAX_VALUE);
            this.fMaxValue.setIncrement(1);
            GridBagConstraints propertyConstraints = new GridBagConstraints();
            propertyConstraints.gridx = 0;
            propertyConstraints.gridy = 0;
            propertyConstraints.fill = 0;
            propertyConstraints.anchor = 17;
            propertyConstraints.insets = new Insets(4, 0, 4, 0);
            this.valuePanel.add((Component)this.fMinValueLabel, propertyConstraints);
            propertyConstraints.gridx = 1;
            propertyConstraints.gridy = 0;
            propertyConstraints.fill = 0;
            propertyConstraints.anchor = 17;
            propertyConstraints.insets = new Insets(4, 0, 4, 4);
            this.valuePanel.add((Component)this.fMinValue, propertyConstraints);
            propertyConstraints.gridx = 2;
            propertyConstraints.gridy = 0;
            propertyConstraints.fill = 0;
            propertyConstraints.anchor = 17;
            propertyConstraints.insets = new Insets(4, 4, 4, 0);
            this.valuePanel.add((Component)this.fMaxValueLabel, propertyConstraints);
            propertyConstraints.gridx = 3;
            propertyConstraints.gridy = 0;
            propertyConstraints.fill = 0;
            propertyConstraints.anchor = 17;
            propertyConstraints.insets = new Insets(4, 0, 4, 0);
            this.valuePanel.add((Component)this.fMaxValue, propertyConstraints);
        }
        return this.valuePanel;
    }

    private JPanel getBarPropertyPanel() {
        BorderJPanel barPropertyPanel = new BorderJPanel();
        barPropertyPanel.setTitle(Language.getString("dialog.parameter.message.setBarProperty", "Bar Property Setting"));
        barPropertyPanel.setLayout(new GridBagLayout());
        this.fWidthLabel = new JLabel(Language.getString("dialog.parameter.message.setBarWidthLabel", "Width:"));
        this.fWidthValue = new EditableNumericSpinner();
        this.fWidthValue.setName("widthValue");
        this.fWidthValue.addNumericSpinnerListener(this);
        if (this.isBiWidthCharacterset()) {
            this.fWidthValue.setMinMax(2, 16);
        } else {
            this.fWidthValue.setMinMax(2, 12);
        }
        this.fWidthValue.setIncrement(1);
        this.fHeightLabel = new JLabel(Language.getString("dialog.parameter.message.setBarHeightLabel", "Height:"));
        this.fHeightValue = new EditableNumericSpinner();
        this.fHeightValue.setName("heightValue");
        this.fHeightValue.addNumericSpinnerListener(this);
        this.fHeightValue.setMinMax(1, 4);
        this.fHeightValue.setIncrement(1);
        GridBagConstraints propertyConstraints = new GridBagConstraints();
        propertyConstraints.gridx = 0;
        propertyConstraints.gridy = 0;
        propertyConstraints.gridwidth = 4;
        propertyConstraints.fill = 0;
        propertyConstraints.anchor = 17;
        barPropertyPanel.add((Component)this.getDirectionPanel(), propertyConstraints);
        propertyConstraints.gridx = 0;
        propertyConstraints.gridy = 1;
        propertyConstraints.gridwidth = 1;
        propertyConstraints.fill = 1;
        propertyConstraints.anchor = 17;
        propertyConstraints.insets = new Insets(4, 4, 4, 0);
        barPropertyPanel.add((Component)this.fWidthLabel, propertyConstraints);
        propertyConstraints.gridx = 1;
        propertyConstraints.gridy = 1;
        propertyConstraints.gridwidth = 1;
        propertyConstraints.fill = 0;
        propertyConstraints.anchor = 17;
        propertyConstraints.insets = new Insets(4, 4, 4, 14);
        barPropertyPanel.add((Component)this.fWidthValue, propertyConstraints);
        propertyConstraints.gridx = 2;
        propertyConstraints.gridy = 1;
        propertyConstraints.gridwidth = 1;
        propertyConstraints.fill = 0;
        propertyConstraints.anchor = 17;
        propertyConstraints.insets = new Insets(4, 14, 4, 4);
        barPropertyPanel.add((Component)this.fHeightLabel, propertyConstraints);
        propertyConstraints.gridx = 3;
        propertyConstraints.gridy = 1;
        propertyConstraints.gridwidth = 1;
        propertyConstraints.fill = 0;
        propertyConstraints.anchor = 13;
        propertyConstraints.insets = new Insets(4, 0, 4, 8);
        barPropertyPanel.add((Component)this.fHeightValue, propertyConstraints);
        return barPropertyPanel;
    }

    public void loadFieldContents() throws ProgramException {
        if (1 == this.fBarGraphElement.getDirection()) {
            this.fvRadioButton.setSelected(true);
            this.fWidthValue.setValue(2);
            this.fWidthValue.setEnabled(false);
            this.fHeightValue.setEnabled(true);
            this.fHeightValue.setValue(this.fBarGraphElement.getLength());
        } else {
            this.fhRadioButton.setSelected(true);
            this.fHeightValue.setValue(1);
            this.fHeightValue.setEnabled(false);
            this.fWidthValue.setEnabled(true);
            this.fWidthValue.setValue(this.fBarGraphElement.getLength());
        }
        this.barselectPanel.setParameterItem(this.fBarGraphElement.getParameterItem());
        this.fMinValue.setValue(this.fBarGraphElement.getMinValue());
        this.fMaxValue.setValue(this.fBarGraphElement.getMaxValue());
    }

    public boolean checkFieldContents() {
        if (this.fMaxValue.getValue() > Short.MAX_VALUE || this.fMinValue.getValue() < Short.MIN_VALUE) {
            new LogoError((Component)this, "error.dialog.invalidValue", "Please enter an integer between -32768 and 32767.", (Object[])new Integer[]{new Integer(Short.MIN_VALUE), new Integer(Short.MAX_VALUE)}, 2, 0).display();
            return false;
        }
        if (this.fMaxValue.getValue() <= this.fMinValue.getValue()) {
            new LogoError(this, "dialog.parameter.message.maxValueLargeThanMinValue", "The MaxValue must large than the MinValue.", 2).display();
            return false;
        }
        if (this.barselectPanel.getParameterItem() == null) {
            new LogoError(this, "dialog.parameter.message.functionBlockNotSelect", "Please select the function block.", 2).display();
            return false;
        }
        this.barGraphElementNew = new BarDisplayElement(this.fBarGraphElement.getID(), this.fBarGraphElement.getParameterItem(), this.fBarGraphElement.getDirection(), this.fBarGraphElement.getLength(), this.fBarGraphElement.getMaxValue(), this.fBarGraphElement.getMinValue());
        if (this.fvRadioButton.isSelected()) {
            this.barGraphElementNew.setDirection(1);
            this.barGraphElementNew.setLength(this.fHeightValue.getValue());
        } else {
            this.barGraphElementNew.setDirection(0);
            this.barGraphElementNew.setLength(this.fWidthValue.getValue());
        }
        this.barGraphElementNew.setMaxValue(this.fMaxValue.getValue());
        this.barGraphElementNew.setMinValue(this.fMinValue.getValue());
        this.barGraphElementNew.setParameterItem(this.barselectPanel.getParameterItem());
        Point startPoint = this.display.getModel().getElementBounds(this.display.getFocusPosition()).getLocation();
        if (startPoint.x + this.barGraphElementNew.getWidth() > this.fDisplayDimension.width || this.updateAction && startPoint.y + this.fBarGraphElement.getHeight() - this.barGraphElementNew.getHeight() < 0 || !this.updateAction && startPoint.y - this.barGraphElementNew.getHeight() + 1 < 0) {
            new LogoError(this, "dialog.parameter.message.insertionNotAllowed", "Insertion is not allowed on the current position.", 2).display();
            return false;
        }
        Point target = new Point(this.display.getFocusPosition().x, this.display.getFocusPosition().y - this.barGraphElementNew.getHeight() + this.fBarGraphElement.getHeight());
        if (this.updateAction) {
            if (!((MessageParameterDisplayModelRTF)this.display.getModel()).replaceBarElement(this.display.getFocusPosition(), target, this.barGraphElementNew)) {
                this.display.showManualEditPanel(false, this.sDialog, this.barGraphElementNew, this.fBarGraphElement);
                return false;
            }
            this.display.clearSelection();
        } else if (!((MessageParameterDisplayModelRTF)this.display.getModel()).setElementAt(this.barGraphElementNew, target)) {
            this.display.showManualEditPanel(false, this.sDialog, this.barGraphElementNew, null);
            return false;
        }
        return true;
    }

    public void spinnerChanged(SpinnerChangedEvent se) {
    }

    private boolean isBiWidthCharacterset() {
        if (this.display.getModel() instanceof MutiCharSetDisplayModel) {
            return ((MutiCharSetDisplayModel)((Object)this.display.getModel())).isBiWidthCharacterset();
        }
        return false;
    }

    public boolean checkChanged() {
        if (!this.updateAction) {
            return true;
        }
        boolean ret = false;
        if (this.fvRadioButton.isSelected() ? 1 != this.fBarGraphElement.getDirection() || this.fHeightValue.getValue() != this.fBarGraphElement.getHeight() : 0 != this.fBarGraphElement.getDirection() || this.fWidthValue.getValue() != this.fBarGraphElement.getWidth()) {
            return true;
        }
        return ret |= this.fMinValue.getValue() != this.fBarGraphElement.getMinValue() || this.fMaxValue.getValue() != this.fBarGraphElement.getMaxValue() || null == this.fBarGraphElement.getParameterItem() || !this.fBarGraphElement.getParameterItem().equals(this.barselectPanel.getParameterItem());
    }

    public void setDialog(SplittedDlg dialog) {
        this.sDialog = dialog;
    }

    public SplittedDlg getDialog() {
        return this.sDialog;
    }

    public boolean isAvailable() {
        return this.barselectPanel.isAvailable();
    }
}

